﻿#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
 
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage,
 
		    [Parameter(Mandatory=$false)]
		    $Component,
 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,
		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
 
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
 
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }

#Setup TS Environment
try
{
    $tsenv = New-Object -COMObject Microsoft.SMS.TSEnvironment
}
catch
{
	Write-Verbose "Not running in a task sequence."
}

$LogPath = $tsenv.Value('_SMSTSLogPath')
$LogFile = "$LogPath\WaaS_LangPack.log"
$Mode = $tsenv.Value('WaaS_TSWaaSMode')
if ($Mode -ne $null){$Component = "$($mode):LangPack"}
else {$Component = "LangPack"}



$WaaSFolderPath = "$($env:ProgramData)\WaaS"


if (Test-Path -Path "$($WaaSFolderPath)\SetLegalNoticeText-OSUpgradeComplete.ps1")
    {
    $SetLegalNoticeTextOSComplete = Get-Content -path "$($WaaSFolderPath)\WaaS_SetLegalNoticeText-OSUpgradeComplete.ps1" -Raw
    CMTraceLog -Message  "Modifying Legal Text Script: $($WaaSFolderPath)\WaaS_SetLegalNoticeText-OSUpgradeComplete.ps1" -Type 1 -LogFile $LogFile -Component $Component
    CMTraceLog -Message  "Modifying Legal Text Script for Language: $($tsenv.Value('SMSTS_WinSystemLocale'))" -Type 1 -LogFile $LogFile -Component $Component
    if ($SetLegalNoticeTextOSComplete | Where-Object -FilterScript { $_ -match '"Windows 10 Upgrade Complete"'})
        {
        ((Get-Content -path "$($WaaSFolderPath)\WaaS_SetLegalNoticeText-OSUpgradeComplete.ps1" -Raw) -replace '"Windows 10 Upgrade Complete"','"Mise à niveau Windows 10 terminée"') | Set-Content -Path "$($WaaSFolderPath)\WaaS_SetLegalNoticeText-OSUpgradeComplete.ps1"
        CMTraceLog -Message  "Changed: Windows 10 Upgrade Complete ->  Mise à niveau Windows 10 terminée" -Type 1 -LogFile $LogFile -Component $Component
        }    
    if ($SetLegalNoticeTextOSComplete | Where-Object -FilterScript { $_ -match '"You can now log back into your Machine."'})   
        {
        ((Get-Content -path "$($WaaSFolderPath)\WaaS_SetLegalNoticeText-OSUpgradeComplete.ps1" -Raw) -replace '"You can now log back into your Machine."','"Vous pouvez maintenant vous connecter à votre ordinateur."') | Set-Content -Path "$($WaaSFolderPath)\WaaS_SetLegalNoticeText-OSUpgradeComplete.ps1"              
        CMTraceLog -Message  "You can now log back into your Machine. ->  Vous pouvez maintenant vous connecter à votre ordinateur." -Type 1 -LogFile $LogFile -Component $Component
        }
    }